jQuery(document).ready(function ($) {
    $(".options_group.show_if_bdcp_bookable_product")
        .closest(".panel")
        .addClass("show_if_bdcp_bookable_product");
    $(".product_data_tabs .bdpcp_bookable_product_options_tab").addClass(
        "show_if_bdcp_bookable_product"
    );

    let bdpcp_booking_dates_options = {
        mode: "range",
        dateFormat: "d-m-Y",
    };
    if (bdpcp_admin_object.booking_dates == "") {
        bdpcp_booking_dates_options.minDate = "today";
    }
    $("#bdpcp_booking_dates").flatpickr(bdpcp_booking_dates_options);

    $("#bdpcp_booking_day_off").flatpickr({
        inline: true,
        mode: "multiple",
        dateFormat: "d-m-Y",
        minDate: "today",
        onReady: function (selectedDates, dateStr, instance) {
            const hideBtn = document.createElement("button");
            hideBtn.textContent = "Close";
            hideBtn.type = "button";
            hideBtn.className = "bdpcp-btn-hide-flatpickr-inline"; // optional, for styling

            hideBtn.addEventListener("click", function () {
                $("#bdpcp_booking_day_off").next(".flatpickr-calendar").toggle();
            });

            instance.calendarContainer.appendChild(hideBtn);
        },
    });
    $("#bdpcp_booking_day_off").next(".flatpickr-calendar").hide();
    $(document).on("click", "#bdpcp_booking_day_off", function () {
        $("#bdpcp_booking_day_off").next(".flatpickr-calendar").toggle();
    });

    $("#bdpcp_booking_week_off").select2();

    $(document).on("change", "#bdpcp_booking_everyday", function () {
        if ($(this).prop("checked")) {
            $("#bdpcp_booking_date_div").hide();
            $("#bdpcp_booking_dates").val("");
        } else {
            $("#bdpcp_booking_date_div").show();
        }
    });
    $("#bdpcp_booking_everyday").trigger("change");

    // time slot code
    $(document).on("click", "#bdpcp_btn_add_time_slot", function () {
        let html = `<tr>
                        <td><input type="time" class="bdpcp_time_slots" name="bdpcp_time_slots[]" value="" style="width: 100%;"></td>
                        <td><input type="number" class="bdpcp_total_slots" name="bdpcp_total_slots[]" value="0" style="width: 100%;"></td>
                        <td>
                            <button type="button" class="button bdpcp_btn_remove_time_slot" style="width: 100%;">
                                Remove
                            </button>
                        </td>
                    </tr>`;
        $("#bdpcp_time_slot_main_div tbody").append(html);
    });

    $(document).on("click", ".bdpcp_btn_remove_time_slot", function () {
        $(this).parents("tr").remove();
    });

    // persn code
    $(document).on("click", "#bdpcp_btn_add_people", function () {
        let html = `<div class="bdpcp-people-div">
						<input type="text" class="bdpcp_people" name="bdpcp_people[]">
						<button type="button" class="button bdpcp_btn_remove_people">
							Remove
						</button>
					</div>`;
        $("#bdpcp_people_main_div").append(html);
    });

    $(document).on("click", ".bdpcp_btn_remove_people", function () {
        $(this).parents(".bdpcp-people-div").remove();
    });

    $(document).on("change", "#bdpcp_people_price", function () {
        if ($(this).prop("checked")) {
            $("#bdpcp_people_price_main_div").show();
        } else {
            $("#bdpcp_people_price_div tbody").html("");
            $("#bdpcp_people_price_main_div").hide();
        }
    });
    $("#bdpcp_people_price").trigger("change");

    $(document).on("click", "#bdpcp_btn_add_people_type_price", function () {
        let basePrice = $("#bdpcp_base_price").val();
        let maxSlotPerTime = $("#bdpcp_max_slot_per_time").val();
        let html = ``;
        html += `<tr>
                    <td>
                        <select class="bdpcp_people_name" name="bdpcp_people_name[]">
                            <option value="person">Person</option>
                            <option value="adult">Adult</option>
                            <option value="child">Child</option>
                        </select>
                    </td>
                    <td>
                        <input type="number" class="bdpcp_people_price" name="bdpcp_people_price[]" value="${basePrice}" style="width: 100%;">
                    </td>
                    <td>
                        <input type="number" class="bdpcp_people_min_slot" min="0" name="bdpcp_people_min_slot[]" value="0" style="width: 100%;">
                    </td>
                    <td>
                        <input type="number" class="bdpcp_people_max_slot" mix="-1" name="bdpcp_people_max_slot[]" value="${maxSlotPerTime}" style="width: 100%;">
                    </td>
                    <td>
                        <button type="button" class="button bdpcp_btn_remove_people_type_price">
                            Remove
                        </button>
                    </td>
                </tr>`;
        $("#bdpcp_people_price_div tbody").append(html);
    });

    $(document).on("input", ".bdpcp_people_max_slot", function () {
        let maxSlotPerTime = $("#bdpcp_max_slot_per_time").val();
        let value = $(this).val();
        if (parseInt(maxSlotPerTime) < parseInt(value)) {
            $(this).val(maxSlotPerTime);
        }
    });

    $(document).on("input", "#bdpcp_max_slot_per_time", function () {
        let maxSlotPerTime = $("#bdpcp_max_slot_per_time").val();
        $(".bdpcp_people_max_slot").each(function () {
            let value = $(this).val();
            if (parseInt(value) > parseInt(maxSlotPerTime)) {
                $(this).val(maxSlotPerTime);
            }
        });
    });

    $(document).on("click", ".bdpcp_btn_remove_people_type_price", function () {
        $(this).parents("tr").remove();
    });

    $(document).on("change", "#bdpcp_unit_type", function () {
        $("#bdpcp_people_price_main_div").hide();
        $("#bdpcp_hour_price_main_div").hide();
        let val = $(this).val();

        if (val == "hour") {
            $("#bdpcp_hour_price").val($("#bdpcp_base_price").val());
            $("#bdpcp_hour_price_main_div").show();
        } else if (val == "people") {
            $("#bdpcp_people_price_main_div").show();
        }
    });
    $("#bdpcp_unit_type").trigger("change");

    $(document).on("change", "#bdpcp_booking_is_manual_time_slot", function () {
        if ($(this).prop("checked")) {
            $("#bdpcp_manual_time_slot_div").show();
            $("#bdpcp_auto_time_slot_div").hide();
        } else {
            $("#bdpcp_manual_time_slot_div").hide();
            $("#bdpcp_auto_time_slot_div").show();
        }
    });
    $("#bdpcp_booking_is_manual_time_slot").trigger("change");

    $(document).on("change", "#bdpcp_booking_start_time", function () {
        let time = $(this).val();
        let end_time = $("#bdpcp_booking_end_time").val();
        if (time > end_time) {
            $("#bdpcp_booking_end_time").val(time);
        }
        $("#bdpcp_booking_end_time").attr("min", time);
    });

    $(document).on("change", "#bdpcp_booking_end_time", function () {
        let time = $(this).val();
        let start_time = $("#bdpcp_booking_start_time").val();
        if (time < start_time) {
            $(this).val(start_time);
        }
    });

    $(document).on("change", "#bdpcp_is_multiple_time_select", function () {
        if ($("#bdpcp_unit_type").val() == "hour") {
            $("#bdpcp_unit_type").val("").trigger("change");
        }
        if ($(this).prop("checked")) {
            $("#bdpcp_unit_type option[value='hour']").prop("disabled", true);
        } else {
            $("#bdpcp_unit_type option[value='hour']").prop("disabled", false);
        }
    });
});
