jQuery(document).ready(async function ($) {
    let bdpcp_deactivation_reasons = [];

    const bccp_response = await fetch(
        "https://conicplex.com/wp-json/picp/v1/deactivation-reasons",
        {
            method: "GET",
        }
    );
    if (bccp_response.ok) {
        const data = await bccp_response.json();
        bdpcp_deactivation_reasons = data.data;
    }

    console.log(bdpcp_deactivation_reasons);
    

    let bdpcp_deactivation_options = ``;
    if (bdpcp_deactivation_reasons.length > 0) {
        for (let bdpcp_deactivation_reason of bdpcp_deactivation_reasons) {
            bdpcp_deactivation_options += `<div class="bdpcp-deactivation-option">
                                            <div>
                                                <input type="radio" name="bdpcp_deactivation_reason" id="bdpcp_deactivation_reason_${
                                                    bdpcp_deactivation_reason.id
                                                }" value="${
                bdpcp_deactivation_reason.id
            }">
                                            </div>
                                            <label for="bdpcp_deactivation_reason_${
                                                bdpcp_deactivation_reason.id
                                            }">${
                bdpcp_deactivation_reason.label
            }</label>
                                            ${
                                                bdpcp_deactivation_reason.is_textbox
                                                    ? `<input type="text" class="bdpcp_reason_text" id="bdpcp_reason_text_${bdpcp_deactivation_reason.id}" placeholder="Please share the reason" style="margin-top: 5px; width: 100%; display: none" />`
                                                    : ``
                                            }
                                        </div>`;
        }
    }

    $("body").append(`
        <div class="bdpcp-deactivation-modal" id="bdpcp_deactivation_modal" style="display: none">
            <div class="bdpcp-deactivation-dialog">
                <div class="bdpcp-deactivation-modal-header">
                    <span class="bdpcp-deactivation-modal-title">QUICK FEEDBACK</span>
                </div>
                <div class="bdpcp-deactivation-modal-content">

                    <span class="bdpcp-deactivation-modal-subtitle">If you have a moment, please share why you are deactivating Booking:</span>

                    <div class="bdpcp-deactivation-options-list">
                        ${bdpcp_deactivation_options}
                    </div>

                    <div class="bdpcp-deactivation-buttons">
                        <div>
                            <button type="button" class="bdpcp-btn-deactivation-submit" id="bdpcp_deactivation_submit">Submit & Deactivate</button>
                            <button type="button" class="bdpcp-btn-deactivation-skip" id="bdpcp_deactivation_skip" style="display: none">Skip & Deactivate</button>
                            <button type="button" class="bdpcp-btn-deactivation-skip" id="bdpcp_deactivation_cancel">Cancel</button>
                        </div>
                        <div>
                            
                        </div>
                    </div>

                    <div class="bdpcp-deactivation-selection-error">Please select any reason.</div>
                </div>
            </div>
        <div>
    `);

    var bdpcp_plugin = "bookingdaddy-pro/bookingdaddy-pro.php";
    var bdpcp_deactivation_link = `tr[data-plugin="${bdpcp_plugin}"] .deactivate a`;

    $(document).on("click", bdpcp_deactivation_link, function (e) {
        e.preventDefault();
        bdpcp_deactivation_modal_show();
    });

    $(document).on("click", "body", function (e) {
        if ($(e.target).hasClass("bdpcp-deactivation-modal")) {
            bdpcp_deactivation_modal_hide();
        }
    });

    $(document).on("click", "#bdpcp_deactivation_submit", function (e) {
        let id = $("input[name='bdpcp_deactivation_reason']:checked").val();
        if (!id) {
            $(".bdpcp-deactivation-selection-error").show();
            return false;
        }
        let text = $(`#bdpcp_reason_text_${id}`).val();
        window.location.href =
            $(bdpcp_deactivation_link).attr("href") +
            `&bdpcp_deactivation_reason=${id}&bdpcp_deactivation_reason_text=${text}&bdpcp_deactivation_nonce=${bdpcp_deactivation.nonce}`;
    });

    $(document).on("click", "#bdpcp_deactivation_skip", function (e) {
        window.location.href = $(bdpcp_deactivation_link).attr("href");
    });

    $(document).on("click", "#bdpcp_deactivation_cancel", function (e) {
        bdpcp_deactivation_modal_hide();
    });

    $(document).on(
        "change",
        "input[name='bdpcp_deactivation_reason']",
        function (e) {
            $(".bdpcp_reason_text").val("").hide();
            $(".bdpcp-deactivation-selection-error").hide();
            let id = $("input[name='bdpcp_deactivation_reason']:checked").val();
            $(`#bdpcp_reason_text_${id}`).show();
        }
    );

    function bdpcp_deactivation_modal_show() {
        $("body").css("overflow", "hidden");
        $("#bdpcp_deactivation_modal").fadeIn();
    }

    function bdpcp_deactivation_modal_hide() {
        $("body").css("overflow", "auto");
        $("#bdpcp_deactivation_modal").fadeOut();
    }
});
