jQuery(document).ready(function ($) {
    var bdpcp_calendar_element = document.getElementById("bdpcp_calendar");
    var bdpcp_calendar = new FullCalendar.Calendar(bdpcp_calendar_element, {
        initialView: "dayGridMonth",
        height: 500,
        headerToolbar: {
            left: "prev,next today",
            center: "title",
            right: "dayGridMonth,timeGridWeek,timeGridDay,listWeek",
        },
        events: bdpcp_object.orders_event,

        dayMaxEventRows: 4,

        eventContent: function (arg) {
            console.log(arg.event);

            const customHtml = document.createElement("div");
            customHtml.style.padding = "2px";
            customHtml.style.cursor = "pointer";
            customHtml.innerHTML = `
              <strong>${arg.event.title}</strong><br/>
              <small">${arg.event.extendedProps.product_name} - ${arg.event.extendedProps.booking_time}</small><br/>
            `;
            return { domNodes: [customHtml] };
        },

        eventClick: function (info) {
            $("#bdpcp_order_modal").css("display", "flex");
            $("body").css("overflow", "hidden");

            let data = info.event.extendedProps;
            console.log(data);

            let html = `<h3>${info.event.title}</h3>`;
            html += `<h4 stype="margin-bottom: 8px;">${data.product_name}</h4>`;
            html += `<p style="margin: 0">Date: ${data.booking_date}</p>`;
            if (data.booking_times) {
                for (let time in data.booking_times) {
                    html += `<p style="margin: 0">Time: ${data.booking_times[time].value}</p>`;
                }
            }

            let subtotal = 0;
            if (data.unit_type_count && data.price_details) {
                for (let unit in data.unit_type_count) {
                    let unit_count = data.unit_type_count[unit];
                    let price = data.price_details[unit].price;
                    let time_count = Object.keys(data.booking_times).length;

                    let total_amount = price * unit_count;
                    if (time_count > 1) {
                        total_amount *= time_count;
                    }

                    html += `<p style="margin: 0">${unit_count} ${bdpcp_ucfirst(
                        unit
                    )} × ${bdpcp_object.currency_symbol + price} ${
                        time_count > 1 ? "× " + time_count + " Times" : ""
                    } = ${bdpcp_object.currency_symbol + total_amount}</p>`;
                    subtotal += total_amount;
                }
            } else {
                let time_count = Object.keys(data.booking_times).length;
                let base_price = data.product_base_price;
                let total_amount = base_price * time_count;
                html += `<p style="margin: 0">${
                    bdpcp_object.currency_symbol + base_price
                } × ${time_count} Times = ${
                    bdpcp_object.currency_symbol + total_amount
                }</p>`;
                subtotal += total_amount;
            }

            html += `<p style="margin: 0">Sub total: ${subtotal}</p>`;
            if (data.product_fixed_base_fee > 0) {
                html += `<p style="margin: 0">Additional fee: ${
                    bdpcp_object.currency_symbol + data.product_fixed_base_fee
                }</p>`;
                subtotal += parseFloat(data.product_fixed_base_fee);
            }
            html += `<p style="margin: 0">Total: ${
                bdpcp_object.currency_symbol + subtotal
            }</p>`;

            html += `<a class="bdpcp-btn-view-order" target="_blank" href="${data.order_link}">View Order</a>`;
            $(".bdpcp-order-modal-body").html(html);
        },

        eventTimeFormat: {
            hour: "numeric",
            minute: "2-digit",
            meridiem: "short",
        },
    });
    bdpcp_calendar.render();

    $(document).on("click", ".bdpcp-btn-order-modal-hide", function () {
        $("#bdpcp_order_modal").css("display", "none");
        $("body").css("overflow", "auto");
    });

    $(document).on("click", "body", function (e) {
        if ($(e.target).hasClass("bdpcp-order-modal")) {
            $("#bdpcp_order_modal").css("display", "none");
            $("body").css("overflow", "auto");
        }
    });

    function bdpcp_ucfirst(str) {
        if (!str) return "";
        return str.charAt(0).toUpperCase() + str.slice(1);
    }
});
