<?php

if (! defined('ABSPATH')) exit; // Exit if accessed directly

global $post;
$bdpcp_product = wc_get_product($post->ID);

$bdpcp_booking_everyday = !empty($bdpcp_product->get_meta('_bdcp_booking_everyday')) ? $bdpcp_product->get_meta('_bdcp_booking_everyday') : 0;
$bdpcp_is_manual_time_slot = !empty($bdpcp_product->get_meta('_bdcp_is_manual_time_slot')) ? $bdpcp_product->get_meta('_bdcp_is_manual_time_slot') : 0;

$bdpcp_booking_start_date = !empty($bdpcp_product->get_meta('_bdcp_start_date')) ? $bdpcp_product->get_meta('_bdcp_start_date') : '';
$bdpcp_booking_end_date = !empty($bdpcp_product->get_meta('_bdcp_end_date')) ? $bdpcp_product->get_meta('_bdcp_end_date') : '';
$bdpcp_time_slots = !empty($bdpcp_product->get_meta('_bdcp_time_slots')) ? $bdpcp_product->get_meta('_bdcp_time_slots') : [];
$bdpcp_booking_week_off = !empty($bdpcp_product->get_meta('_bdcp_booking_week_off')) ? $bdpcp_product->get_meta('_bdcp_booking_week_off') : [];
$bdpcp_booking_duration = !empty($bdpcp_product->get_meta('_bdcp_duration')) ? $bdpcp_product->get_meta('_bdcp_duration') : 0;
$bdpcp_base_price = !empty($bdpcp_product->get_meta('_bdcp_base_price')) ? $bdpcp_product->get_meta('_bdcp_base_price') : 0;
$bdpcp_fixed_base_fee = !empty($bdpcp_product->get_meta('_bdcp_fixed_base_fee')) ? $bdpcp_product->get_meta('_bdcp_fixed_base_fee') : 0;

$bdpcp_unit_type = !empty($bdpcp_product->get_meta('_bdcp_unit_type')) ? $bdpcp_product->get_meta('_bdcp_unit_type') : '';
$bdpcp_price_details = !empty($bdpcp_product->get_meta('_bdcp_price_details')) ? $bdpcp_product->get_meta('_bdcp_price_details') : [];

$bdpcp_start_time = !empty($bdpcp_product->get_meta('_bdcp_start_time')) ? $bdpcp_product->get_meta('_bdcp_start_time') : '';
$bdpcp_end_time = !empty($bdpcp_product->get_meta('_bdcp_end_time')) ? $bdpcp_product->get_meta('_bdcp_end_time') : '';
$bdpcp_buffer_time = !empty($bdpcp_product->get_meta('_bdcp_buffer_time')) ? $bdpcp_product->get_meta('_bdcp_buffer_time') : 0;
$bdpcp_time_duration = !empty($bdpcp_product->get_meta('_bdcp_time_duration')) ? $bdpcp_product->get_meta('_bdcp_time_duration') : 0;

$bdpcp_time_duration_type = !empty($bdpcp_product->get_meta('_bdcp_time_duration_type')) ? $bdpcp_product->get_meta('_bdcp_time_duration_type') : '';
$bdpcp_buffer_time_type = !empty($bdpcp_product->get_meta('_bdcp_buffer_time_type')) ? $bdpcp_product->get_meta('_bdcp_buffer_time_type') : '';
$bdpcp_max_slot_per_time = !empty($bdpcp_product->get_meta('_bdcp_max_slot_per_time')) ? $bdpcp_product->get_meta('_bdcp_max_slot_per_time') : 0;
$bdpcp_is_multiple_time_select = !empty($bdpcp_product->get_meta('_bdcp_is_multiple_time_select')) ? $bdpcp_product->get_meta('_bdcp_is_multiple_time_select') : 0;
$bdpcp_booking_day_off = !empty($bdpcp_product->get_meta('_bdcp_booking_day_off')) ? $bdpcp_product->get_meta('_bdcp_booking_day_off') : [];

wp_enqueue_style('flatpickr-css', BDPCP_ROOT_URL . 'admin/css/flatpickr.min.css', array(), $this->version, 'all');
wp_enqueue_script('flatpickr-css', BDPCP_ROOT_URL . 'admin/js/flatpickr.js', array('jquery'), $this->version, false);

wp_enqueue_style($this->plugin_name, BDPCP_ROOT_URL . 'admin/css/bdpcp-admin.css', array(), $this->version, 'all');
wp_enqueue_script($this->plugin_name, BDPCP_ROOT_URL . 'admin/js/bdpcp-admin.js', array('jquery'), $this->version, false);

$bdpcp_booking_dates = '';
if (empty($bdpcp_booking_everyday) && !empty($bdpcp_booking_start_date) && !empty($bdpcp_booking_end_date)) {
    $bdpcp_booking_start_date = gmdate('d-m-Y', strtotime($bdpcp_booking_start_date));
    $bdpcp_booking_end_date = gmdate('d-m-Y', strtotime($bdpcp_booking_end_date));
    $bdpcp_booking_dates = "$bdpcp_booking_start_date to $bdpcp_booking_end_date";
}

wp_localize_script($this->plugin_name, 'bdpcp_admin_object', array(
    'start_date' => $bdpcp_booking_start_date,
    'end_date' => $bdpcp_booking_end_date,
    'booking_dates' => $bdpcp_booking_dates,
));

?>

<?php wp_nonce_field('bdpcp_admin_nonce', 'bdpcp_admin_nonce'); ?>

<div id="bdpcp_bookable_product_options_product_data" class="panel woocommerce_options_panel show_if_bdcp_bookable_product">
    <div class="bdpcp-settings-section">
        <div class="bdpcp-settings-section-title">
            <?php esc_html_e('Booking Settings', 'bookingdaddy-pro') ?>
        </div>
        <div class="bdpcp-settings-section-content">
            <div class="bdpcp-setting-form-group">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_booking_everyday" class="bdpcp-setting-form-label"><?php esc_html_e('Allow Daily Booking', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <input type="checkbox" name="bdpcp_booking_everyday" id="bdpcp_booking_everyday" <?php echo !empty($bdpcp_booking_everyday) ? 'checked' : '' ?>>
                    <p class="description"><?php esc_html_e('Allow bookings every day without specific date restrictions.', 'bookingdaddy-pro'); ?></p>
                </div>
            </div>

            <div class="bdpcp-setting-form-group" id="bdpcp_booking_date_div">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_booking_dates" class="bdpcp-setting-form-label"><?php esc_html_e('Select Booking Dates', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">

                    <input type="text" name="bdpcp_booking_dates" id="bdpcp_booking_dates" value="<?php echo esc_html($bdpcp_booking_dates) ?>">
                    <p class="description"><?php esc_html_e('Choose a specific date range available for booking.', 'bookingdaddy-pro'); ?></p>
                </div>
            </div>

            <div class="bdpcp-setting-form-group">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_booking_day_off" class="bdpcp-setting-form-label"><?php esc_html_e('Set Day Off', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <input type="text" id="bdpcp_booking_day_off" name="bdpcp_booking_day_off" value="<?php echo esc_html(implode(', ', $bdpcp_booking_day_off)); ?>">
                    <p class="description"><?php esc_html_e('Specify individual days off or holidays that will be unavailable for booking.', 'bookingdaddy-pro'); ?></p>
                </div>
            </div>

            <div class="bdpcp-setting-form-group">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_booking_week_off" class="bdpcp-setting-form-label"><?php esc_html_e('Set Weekly Off Days', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <select name="bdpcp_booking_week_off[]" id="bdpcp_booking_week_off" multiple style="width: 100%; max-width: 25em;">
                        <option value="1" <?php echo in_array('1', $bdpcp_booking_week_off) ? 'selected' : '' ?>><?php esc_html_e('Monday', 'bookingdaddy-pro') ?></option>
                        <option value="2" <?php echo in_array('2', $bdpcp_booking_week_off) ? 'selected' : '' ?>><?php esc_html_e('Tuesday', 'bookingdaddy-pro') ?></option>
                        <option value="3" <?php echo in_array('3', $bdpcp_booking_week_off) ? 'selected' : '' ?>><?php esc_html_e('Wednesday', 'bookingdaddy-pro') ?></option>
                        <option value="4" <?php echo in_array('4', $bdpcp_booking_week_off) ? 'selected' : '' ?>><?php esc_html_e('Thursday', 'bookingdaddy-pro') ?></option>
                        <option value="5" <?php echo in_array('5', $bdpcp_booking_week_off) ? 'selected' : '' ?>><?php esc_html_e('Friday', 'bookingdaddy-pro') ?></option>
                        <option value="6" <?php echo in_array('6', $bdpcp_booking_week_off) ? 'selected' : '' ?>><?php esc_html_e('Saturday', 'bookingdaddy-pro') ?></option>
                        <option value="0" <?php echo in_array('0', $bdpcp_booking_week_off) ? 'selected' : '' ?>><?php esc_html_e('Sunday', 'bookingdaddy-pro') ?></option>
                    </select>
                    <p class="description"><?php esc_html_e('Select fixed weekdays that will be blocked from booking (e.g., Sundays).', 'bookingdaddy-pro'); ?></p>
                </div>
            </div>

            <div class="bdpcp-setting-form-group">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_booking_is_manual_time_slot" class="bdpcp-setting-form-label"><?php esc_html_e('Enable Custom Time Slots', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <input type="checkbox" name="bdpcp_booking_is_manual_time_slot" id="bdpcp_booking_is_manual_time_slot" value="1" <?php echo !empty($bdpcp_is_manual_time_slot) ? 'checked' : '' ?>>
                    <p class="description"><?php esc_html_e('Manually set specific time slots instead of using automatic time intervals.', 'bookingdaddy-pro'); ?></p>
                </div>
            </div>

            <div id="bdpcp_auto_time_slot_div" style="display: none;">
                <div class="bdpcp-setting-form-group">
                    <div class="bdpcp-setting-label-div">
                        <label for="bdpcp_booking_times" class="bdpcp-setting-form-label"><?php esc_html_e('Time Slot Range', 'bookingdaddy-pro') ?></label>
                    </div>
                    <div class="bdpcp-setting-control-div" style="flex-direction: row; gap: 20px; align-items: center;">
                        <input type="time" name="bdpcp_booking_start_time" id="bdpcp_booking_start_time" value="<?php echo !empty($bdpcp_start_time) ? esc_html($bdpcp_start_time) : '' ?>">
                        <div><strong><?php esc_html_e('to', 'bookingdaddy-pro') ?></strong></div>
                        <input type="time" name="bdpcp_booking_end_time" id="bdpcp_booking_end_time" value="<?php echo !empty($bdpcp_end_time) ? esc_html($bdpcp_end_time) : '' ?>">
                    </div>
                </div>

                <!-- Allow Multiple Booking -->
                <div class="bdpcp-setting-form-group">
                    <div class="bdpcp-setting-label-div">
                        <label for="bdpcp_is_multiple_time_select" class="bdpcp-setting-form-label"><?php esc_html_e('Allow Multiple Time Slot Selection', 'bookingdaddy-pro') ?></label>
                    </div>
                    <div class="bdpcp-setting-control-div">
                        <input type="checkbox" name="bdpcp_is_multiple_time_select" id="bdpcp_is_multiple_time_select" value="1" <?php echo !empty($bdpcp_is_multiple_time_select) ? 'checked' : '' ?>>
                        <p class="description"><?php esc_html_e('Enable users to select multiple time slots in one booking.', 'bookingdaddy-pro'); ?></p>
                    </div>
                </div>

                <!-- Duration -->
                <div class="bdpcp-setting-form-group">
                    <div class="bdpcp-setting-label-div">
                        <label for="bdpcp_booking_time_duration" class="bdpcp-setting-form-label"><?php esc_html_e('Booking Duration', 'bookingdaddy-pro') ?></label>
                    </div>
                    <div class="bdpcp-setting-control-div">
                        <div class="bdpcp-d-flex-row-gap-10px">
                            <input type="number" name="bdpcp_booking_time_duration" id="bdpcp_booking_time_duration" value="<?php echo esc_html($bdpcp_time_duration) ?>">
                            <select name="bdpcp_time_duration_type" id="bdpcp_time_duration_type">
                                <option value="minute" <?php echo $bdpcp_time_duration_type == 'minute' ? 'selected' : '' ?>><?php esc_html_e('Minute', 'bookingdaddy-pro') ?></option>
                                <option value="hour" <?php echo $bdpcp_time_duration_type == 'hour' ? 'selected' : '' ?>><?php esc_html_e('Hour', 'bookingdaddy-pro') ?></option>
                            </select>
                        </div>
                        <p class="description"><?php esc_html_e('Set the duration of each booking (e.g., 30 minutes, 1 hour).', 'bookingdaddy-pro'); ?></p>
                    </div>
                </div>

                <!-- Buffer Time -->
                <div class="bdpcp-setting-form-group">
                    <div class="bdpcp-setting-label-div">
                        <label for="bdpcp_booking_buffer_time" class="bdpcp-setting-form-label"><?php esc_html_e('Buffer Time Between Bookings', 'bookingdaddy-pro') ?></label>
                    </div>
                    <div class="bdpcp-setting-control-div">
                        <div class="bdpcp-d-flex-row-gap-10px">
                            <input type="number" name="bdpcp_booking_buffer_time" id="bdpcp_booking_buffer_time" value="<?php echo esc_html($bdpcp_buffer_time) ?>">
                            <select name="bdpcp_buffer_time_type" id="bdpcp_buffer_time_type">
                                <option value="minute" <?php echo $bdpcp_buffer_time_type == 'minute' ? 'selected' : '' ?>><?php esc_html_e('Minute', 'bookingdaddy-pro') ?></option>
                                <option value="hour" <?php echo $bdpcp_buffer_time_type == 'hour' ? 'selected' : '' ?>><?php esc_html_e('Hour', 'bookingdaddy-pro') ?></option>
                            </select>
                        </div>
                        <p class="description"><?php esc_html_e('Add a gap between consecutive bookings to allow for preparation or cleanup.', 'bookingdaddy-pro'); ?></p>
                    </div>
                </div>

                <!-- Maximum Booking per Time Slots -->
                <div class="bdpcp-setting-form-group">
                    <div class="bdpcp-setting-label-div">
                        <label for="bdpcp_max_slot_per_time" class="bdpcp-setting-form-label"><?php esc_html_e('Maximum Bookings Per Time Slot', 'bookingdaddy-pro') ?></label>
                    </div>
                    <div class="bdpcp-setting-control-div">
                        <input type="number" name="bdpcp_max_slot_per_time" id="bdpcp_max_slot_per_time" value="<?php echo esc_html($bdpcp_max_slot_per_time) ?>">
                        <p class="description"><?php esc_html_e('Limit the number of bookings allowed for each time slot.', 'bookingdaddy-pro'); ?></p>
                    </div>
                </div>
            </div>

            <div class="bdpcp-setting-form-group" id="bdpcp_manual_time_slot_div">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_booking_time_slots" class="bdpcp-setting-form-label"><?php esc_html_e('Time Slots', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">

                    <table cellpadding="5" border="0" cellspacing="0" id="bdpcp_time_slot_main_div">
                        <thead>
                            <tr>
                                <th><?php esc_html_e('Time', 'bookingdaddy-pro') ?></th>
                                <th><?php esc_html_e('Total Slots', 'bookingdaddy-pro') ?></th>
                                <th><?php esc_html_e('Action', 'bookingdaddy-pro') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if (!empty($bdpcp_time_slots)) {
                                foreach ($bdpcp_time_slots as $key => $slot) {

                            ?>
                                    <tr>
                                        <td><input type="time" class="bdpcp_time_slots" name="bdpcp_time_slots[]" value="<?php echo esc_html($key) ?>" style="width: 100%;"></td>
                                        <td><input type="number" class="bdpcp_total_slots" name="bdpcp_total_slots[]" value="<?php echo esc_html($slot['total_slot'] ?? 0) ?>" style="width: 100%;"></td>
                                        <td>
                                            <button type="button" class="button bdpcp_btn_remove_time_slot" style="width: 100%;">
                                                <?php esc_html_e('Remove', 'bookingdaddy-pro') ?>
                                            </button>
                                        </td>
                                    </tr>
                            <?php
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                    <div style="display: flex; justify-content: end; margin: 10px 5px 0 0;">
                        <button type="button" class="button" id="bdpcp_btn_add_time_slot"><?php esc_html_e('Add New', 'bookingdaddy-pro') ?></button>
                    </div>
                </div>
            </div>

            <div class="bdpcp-setting-form-group" id="bdpcp_people_details_div" style="display: none;">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_people_main_div" class="bdpcp-setting-form-label"><?php esc_html_e('people Details', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <div class="bdpcp-people-main-div" id="bdpcp_people_main_div">

                    </div>
                    <div>
                        <button type="button" class="button" id="bdpcp_btn_add_people"><?php esc_html_e('Add New', 'bookingdaddy-pro') ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="bdpcp-settings-section">
        <div class="bdpcp-settings-section-title">
            <?php esc_html_e('Price Settings', 'bookingdaddy-pro') ?>
        </div>
        <div class="bdpcp-settings-section-content">

            <div class="bdpcp-setting-form-group" id="bdpcp_booking_date_div">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_base_price" class="bdpcp-setting-form-label"><?php esc_html_e('Base price', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <input type="text" name="bdpcp_base_price" id="bdpcp_base_price" value="<?php echo esc_html($bdpcp_base_price) ?>">
                    <p class="description"><?php esc_html_e('Set the default price before any additional fees or per-person pricing.', 'bookingdaddy-pro'); ?></p>
                </div>
            </div>

            <div class="bdpcp-setting-form-group" id="bdpcp_booking_date_div">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_fixed_base_fee" class="bdpcp-setting-form-label"><?php esc_html_e('Additional Fee on Base Price', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <input type="text" name="bdpcp_fixed_base_fee" id="bdpcp_fixed_base_fee" value="<?php echo esc_html($bdpcp_fixed_base_fee) ?>">
                    <p class="description"><?php esc_html_e('Specify any extra charges applied to the base price.', 'bookingdaddy-pro'); ?></p>
                </div>
            </div>

            <div class="bdpcp-setting-form-group" id="cpbp_people_price_div">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_people_price" class="bdpcp-setting-form-label"><?php esc_html_e('Pricing Unit', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <select name="bdpcp_unit_type" id="bdpcp_unit_type">
                        <option value="">Select unit</option>
                        <option value="hour" <?php echo $bdpcp_unit_type == 'hour' ? 'selected' : '' ?>><?php esc_html_e('Hour', 'bookingdaddy-pro') ?></option>
                        <option value="people" <?php echo $bdpcp_unit_type == 'people' ? 'selected' : '' ?>><?php esc_html_e('People', 'bookingdaddy-pro') ?></option>
                    </select>
                    <p class="description"><?php esc_html_e('Select how the pricing is calculated (e.g., per person, per hour).', 'bookingdaddy-pro'); ?></p>
                </div>
            </div>

            <div class="bdpcp-setting-form-group" id="bdpcp_hour_price_main_div" style="display: none;">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_hour_price" class="bdpcp-setting-form-label"><?php esc_html_e('Hour Price', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <table cellpadding="5" border="0" cellspacing="0">
                        <tr>
                            <th style="text-align: left;"><?php esc_html_e('Hours', 'bookingdaddy-pro') ?></td>
                            <th style="text-align: left;"><?php esc_html_e('Price', 'bookingdaddy-pro') ?></td>
                            <th style="text-align: left;"><?php esc_html_e('Min Slot', 'bookingdaddy-pro') ?></td>
                            <th style="text-align: left;"><?php esc_html_e('Max Slot', 'bookingdaddy-pro') ?></td>
                            <th style="text-align: left;"><?php esc_html_e('Editable', 'bookingdaddy-pro') ?></td>
                        </tr>
                        <tr>
                            <td><input type="number" value="<?php echo esc_html($bdpcp_price_details['hour']['hours'] ?? 0) ?>" id="bdpcp_hours" class="bdpcp_hours" name="bdpcp_hours" style="width: 100%;"></td>
                            <td><input type="number" value="<?php echo esc_html($bdpcp_price_details['hour']['price'] ?? 0) ?>" id="bdpcp_hour_price" class="bdpcp_hour_price" name="bdpcp_hour_price" step="0.01" style="width: 100%;"></td>
                            <td><input type="number" value="<?php echo esc_html($bdpcp_price_details['hour']['min_slot'] ?? 0) ?>" id="bdpcp_hour_min_slot" class="bdpcp_hour_min_slot" name="bdpcp_hour_min_slot" style="width: 100%;"></td>
                            <td><input type="number" value="<?php echo esc_html($bdpcp_price_details['hour']['max_slot'] ?? 0) ?>" id="bdpcp_hour_max_slot" class="bdpcp_hour_max_slot" name="bdpcp_hour_max_slot" style="width: 100%;"></td>
                            <td style="text-align: center;"><input type="checkbox" name="bdpcp_hour_editable" id="bdpcp_hour_editable" id="bdpcp_hour_editable" class="bdpcp_hour_editable" value="1" <?php echo (isset($bdpcp_price_details['hour']['editable']) && !empty($bdpcp_price_details['hour']['editable'])) ? 'checked' : '' ?>></td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="bdpcp-setting-form-group" id="bdpcp_people_price_main_div" style="display: none;">
                <div class="bdpcp-setting-label-div">
                    <label for="bdpcp_people_price_div" class="bdpcp-setting-form-label"><?php esc_html_e('People Price', 'bookingdaddy-pro') ?></label>
                </div>
                <div class="bdpcp-setting-control-div">
                    <table id="bdpcp_people_price_div" cellpadding="5" border="0" cellspacing="0">
                        <thead>
                            <tr>
                                <th><?php esc_html_e('Type', 'bookingdaddy-pro') ?></th>
                                <th><?php esc_html_e('Price', 'bookingdaddy-pro') ?></th>
                                <th><?php esc_html_e('Min', 'bookingdaddy-pro') ?></th>
                                <th><?php esc_html_e('Max', 'bookingdaddy-pro') ?></th>
                                <th><?php esc_html_e('Action', 'bookingdaddy-pro') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if (!empty($bdpcp_price_details)) {
                                foreach ($bdpcp_price_details as $key => $value) { ?>
                                    <tr>
                                        <td>
                                            <select class="bdpcp_people_name" name="bdpcp_people_name[]">
                                                <option value="person" <?php echo $key == 'person' ? 'selected' : '' ?>><?php esc_html_e('Person', 'bookingdaddy-pro') ?></option>
                                                <option value="adult" <?php echo $key == 'adult' ? 'selected' : '' ?>><?php esc_html_e('Adult', 'bookingdaddy-pro') ?></option>
                                                <option value="child" <?php echo $key == 'child' ? 'selected' : '' ?>><?php esc_html_e('Child', 'bookingdaddy-pro') ?></option>
                                            </select>
                                        </td>
                                        <td>
                                            <input type="number" class="bdpcp_people_price" name="bdpcp_people_price[]" value="<?php echo esc_html($value['price']) ?>" style="width: 100%;">
                                        </td>
                                        <td>
                                            <input type="number" class="bdpcp_people_min_slot" min="0" name="bdpcp_people_min_slot[]" value="<?php echo esc_html($value['min_slot']) ?>" style="width: 100%;">
                                        </td>
                                        <td>
                                            <input type="number" class="bdpcp_people_max_slot" min="-1" name="bdpcp_people_max_slot[]" value="<?php echo esc_html($value['max_slot']) ?>" style="width: 100%;">
                                        </td>
                                        <td>
                                            <button type="button" class="button bdpcp_btn_remove_people_type_price">
                                                <?php esc_html_e('Remove', 'bookingdaddy-pro') ?>
                                            </button>
                                        </td>
                                    </tr>

                            <?php }
                            }
                            ?>
                        </tbody>
                    </table>
                    <div style="display: flex;justify-content: end;margin-top: 10px;">
                        <button type="button" class="button" id="bdpcp_btn_add_people_type_price"><?php esc_html_e('Add New', 'bookingdaddy-pro') ?></button>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>