<?php

if (! defined('ABSPATH')) exit;

$order_args = array(
    'limit' => -1,
);

if (!class_exists('WooCommerce')) {
    echo '<div class="notice notice-error"><p>' . esc_html__('WooCommerce is not installed or activated. Please install and activate WooCommerce to use this feature.', 'bookingdaddy-pro') . '</p></div>';
    return;
}

$bdpcp_orders_event = [];
$bdpcp_orders = wc_get_orders($order_args);

$orderColors = [
    'processing' => '#198754',
    'pending' => '#FFC107',
    'cancelled' => '#DC3545',
];

$textColors = [
    'processing' => '#F8F9FA',
    'pending' => '#212529',
    'cancelled' => '#F8F9FA',
];

foreach ($bdpcp_orders as $bdpcp_order) {

    $customer_id = $bdpcp_order->get_customer_id();
    $customer = new WC_Customer($customer_id);

    $booking_date = $bdpcp_order->get_meta('_bdcp_booking_date');
    $booking_times = $bdpcp_order->get_meta('_bdcp_booking_time', false);
    $unit_type_count = $bdpcp_order->get_meta('_bdcp_unit_type_count');
    $price_details = $bdpcp_order->get_meta('_bdcp_price_details');

    $customer_name = $customer->get_first_name() . ' ' . $customer->get_last_name();

    $items = $bdpcp_order->get_items();
    $first_item = reset($items);
    $product_name = $first_item->get_name();
    $product_id = $first_item->get_product_id();
    $product_base_price = get_post_meta($product_id, '_bdcp_base_price', true);
    $product_fixed_base_fee = get_post_meta($product_id, '_bdcp_fixed_base_fee', true);

    $order_link = $bdpcp_order->get_edit_order_url();

    if (!empty($booking_times)) {
        foreach ($booking_times as $booking_time) {
            $bdpcp_orders_event[] = [
                'start' => gmdate('Y-m-d H:i:s', strtotime($booking_date . ' ' . $booking_time->value)),
                // 'backgroundColor' => "#198754",
                'backgroundColor' => $orderColors[$bdpcp_order->status],
                'borderColor' => $orderColors[$bdpcp_order->status],
                'textColor' => $textColors[$bdpcp_order->status],
                'title' => $customer_name,
                'product_name' => $product_name,
                'order_id' => $bdpcp_order->get_id(),
                'booking_times' => $booking_times,
                'booking_time' => gmdate('h:i A', strtotime($booking_date . ' ' . $booking_time->value)),
                'booking_date' => gmdate('d-m-Y', strtotime($booking_date)),
                'display' => "block",
                'unit_type_count' => !empty($unit_type_count) ? $unit_type_count : null,
                'price_details' => !empty($price_details) ? $price_details : null,
                'order_link' => $order_link,
                'product_base_price' => $product_base_price,
                'product_fixed_base_fee' => $product_fixed_base_fee,
            ];
        }
    } else {
        $bdpcp_orders_event[] = [
            'start' => gmdate('Y-m-d', strtotime($booking_date)),
            // 'backgroundColor' => "#198754",
            'backgroundColor' => !empty($orderColors[$bdpcp_order->status]) ? $orderColors[$bdpcp_order->status] : '',
            'borderColor' => !empty($orderColors[$bdpcp_order->status]) ? $orderColors[$bdpcp_order->status]  : '',
            'textColor' => "#F8F9FA",
            'title' => $customer_name,
            'product_name' => $product_name,
            'order_id' => $bdpcp_order->get_id(),
            'booking_times' => $booking_times,
            'booking_time' => null,
            'booking_date' => gmdate('d-m-Y', strtotime($booking_date)),
            'display' => "block",
            'unit_type_count' => !empty($unit_type_count) ? $unit_type_count : null,
            'price_details' => !empty($price_details) ? $price_details : null,
            'order_link' => $order_link,
            'product_base_price' => $product_base_price,
            'product_fixed_base_fee' => $product_fixed_base_fee,
        ];
    }
}

wp_enqueue_style($this->plugin_name . '-orders', BDPCP_ROOT_URL . 'admin/css/bdpcp-orders.css', array(), $this->version, 'all');
wp_enqueue_script($this->plugin_name . '-fullcalendar', BDPCP_ROOT_URL . 'admin/js/bdpcp-fullcalendar.js', array('jquery'), $this->version, false);
wp_enqueue_script($this->plugin_name . '-orders', BDPCP_ROOT_URL . 'admin/js/bdpcp-orders.js', array('jquery'), $this->version, false);
wp_localize_script(
    $this->plugin_name . '-orders',
    'bdpcp_object',
    [
        'orders_event' => $bdpcp_orders_event,
        'currency_symbol' => get_woocommerce_currency_symbol(),
    ]
);

?>

<div class="wrap">
    <h1><?php esc_html_e('Bookings', 'bookingdaddy-pro') ?></h1>

    <div class="bdpcp-order-color-container">
        <?php foreach ($orderColors as $key => $value): ?>
            <div class="bdpcp-order-color-item">
                <div class="bdpcp-order-color" style="background-color: <?php echo esc_html($value) ?>;"></div>
                <div class="bdpcp-order-color-text">
                    <?php echo esc_html(ucfirst($key) . ' booking') ?> 
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <div id='bdpcp_calendar'></div>
</div>

<div class="bdpcp-order-modal" id="bdpcp_order_modal">
    <div class="bdpcp-order-modal-content">
        <div class="bdpcp-order-modal-header">
            <h3 class="bdpcp-order-modal-title"><?php esc_html_e('Order Details', 'bookingdaddy-pro'); ?></h3>
            <button class="bdpcp-order-modal-close bdpcp-btn-order-modal-hide">&times;</button>
        </div>
        <div class="bdpcp-order-modal-body">
        </div>
    </div>
</div>