<?php

if (! defined('ABSPATH')) exit; // Exit if accessed directly

$default = [
    'form_background_color' => '#ffffff',
    'form_border_radius' => 8,
    'form_border_color' => '#808080',
    'form_label_size' => 14,
    'form_label_color' => '#212529',
    'form_control_background_color' => '#ffffff',
    'form_control_text_color' => '#000000',
    'form_control_border_radius' => 8,

    'book_button_text' => 'Book Now',
    'book_button_background_color' => '#212529',
    'book_button_text_color' => '#F8F9FA',

    'unit_type_background_color' => '#212529',
    'unit_type_text_color' => '#F8F9FA',

    'date_selection_label' => 'Select Date',
    'time_selection_label' => 'Select Time',
    'duration_label' => 'Duration',
    'sub_total_label' => 'Sub Total',
    'additional_fee_label' => 'Additional Fee',
    'total_amount_label' => 'Total Amount',

    'date_selection_error' => 'Please select date.',
    'time_selection_error' => 'Please select time.',
    'unit_selection_error' => 'Please select slot.',
];

if (isset($_POST['bdpcp_setting_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['bdpcp_setting_nonce'])), 'bdpcp_setting_nonce_action')) {
    if (isset($_POST['bdpcp_restore_default'])) {
        update_option('_bdcp_settings', $default, false);
    } elseif (isset($_POST['bdpcp_settings'])) {
        update_option('_bdcp_settings', array_map('sanitize_text_field', wp_unslash($_POST['bdpcp_settings'])), false);
    }
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Settings saved.', 'bookingdaddy-pro') . '</p></div>';
}

wp_enqueue_style('wp-color-picker');
wp_enqueue_script('wp-color-picker');

wp_enqueue_style($this->plugin_name . '-setting', BDPCP_ROOT_URL . 'admin/css/bdpcp-setting.css', array(), $this->version, 'all');
wp_enqueue_script($this->plugin_name . '-setting', BDPCP_ROOT_URL . 'admin/js/bdpcp-setting.js', array('jquery'), $this->version, false);

$bdpcp_settings = get_option('_bdcp_settings', []);

$bdpcp_setting_default = function ($key) use ($bdpcp_settings, $default) {
    if (isset($bdpcp_settings[$key])) {
        return esc_html($bdpcp_settings[$key]);
    }
    return esc_html($default[$key]);
};

?>

<div class="wrap">
    <h1><?php esc_html_e('Settings', 'bookingdaddy-pro') ?></h1>

    <form action="" method="post">

        <?php wp_nonce_field('bdpcp_setting_nonce_action', 'bdpcp_setting_nonce'); ?>
        <?php settings_fields('tabcp_settings_group'); ?>
        <?php do_settings_sections('tabcp_settings_group'); ?>

        <div class="bdpcp-tabs">
            <button class="button bdpcp-tab-button button-primary" type="button"><?php esc_html_e('Styles', 'bookingdaddy-pro') ?></button>
            <button class="button bdpcp-tab-button" type="button"><?php esc_html_e('Labels', 'bookingdaddy-pro') ?></button>
            <button class="button bdpcp-tab-button" type="button"><?php esc_html_e('Error Messages', 'bookingdaddy-pro') ?></button>
        </div>

        <div>
            <div class="bdpcp-tab-content">

                <h1><?php esc_html_e('Styles', 'bookingdaddy-pro') ?></h1>

                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_form_background_color"><?php esc_html_e('Form Background Color', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[form_background_color]" type="text" id="bdpcp_settings_form_background_color" value="<?php echo esc_html($bdpcp_setting_default('form_background_color')); ?>" class="regular-text bdpcp-wp-color-picker"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_form_border_color"><?php esc_html_e('Form Border Color', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[form_border_color]" type="text" id="bdpcp_settings_form_border_color" value="<?php echo esc_html($bdpcp_setting_default('form_border_color')); ?>" class="regular-text bdpcp-wp-color-picker"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_form_label_color"><?php esc_html_e('Form Label Color', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[form_label_color]" type="text" id="bdpcp_settings_form_label_color" value="<?php echo esc_html($bdpcp_setting_default('form_label_color')); ?>" class="regular-text bdpcp-wp-color-picker"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_form_control_background_color"><?php esc_html_e('Form Control Background Color', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[form_control_background_color]" type="text" id="bdpcp_settings_form_control_background_color" value="<?php echo esc_html($bdpcp_setting_default('form_control_background_color')); ?>" class="regular-text bdpcp-wp-color-picker"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_form_control_text_color"><?php esc_html_e('Form Control Text Color', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[form_control_text_color]" type="text" id="bdpcp_settings_form_control_text_color" value="<?php echo esc_html($bdpcp_setting_default('form_control_text_color')); ?>" class="regular-text bdpcp-wp-color-picker"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_form_border_radius"><?php esc_html_e('Form Border Radius', 'bookingdaddy-pro') ?></label></th>
                            <td>
                                <input name="bdpcp_settings[form_border_radius]" type="number" min="0" id="bdpcp_settings_form_border_radius" value="<?php echo esc_html($bdpcp_setting_default('form_border_radius')); ?>" class="regular-text">
                                <p class="description"><?php esc_html_e('Enter border radius in pixels (PX).', 'bookingdaddy-pro'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_form_label_size"><?php esc_html_e('Form Label Size', 'bookingdaddy-pro') ?></label></th>
                            <td>
                                <input name="bdpcp_settings[form_label_size]" type="number" min="0" id="bdpcp_settings_form_label_size" value="<?php echo esc_html($bdpcp_setting_default('form_label_size')); ?>" class="regular-text">
                                <p class="description"><?php esc_html_e('Enter font size in pixels (PX).', 'bookingdaddy-pro'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_form_control_border_radius"><?php esc_html_e('Form Control Border Radius', 'bookingdaddy-pro') ?></label></th>
                            <td>
                                <input name="bdpcp_settings[form_control_border_radius]" type="number" min="0" id="bdpcp_settings_form_control_border_radius" value="<?php echo esc_html($bdpcp_setting_default('form_control_border_radius')); ?>" class="regular-text">
                                <p class="description"><?php esc_html_e('Enter border radius in pixels (PX).', 'bookingdaddy-pro'); ?></p>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row"><label for="bdpcp_settings_book_button_text"><?php esc_html_e('Book Button Text', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[book_button_text]" type="text" min="0" id="bdpcp_settings_book_button_text" value="<?php echo esc_html($bdpcp_setting_default('book_button_text')); ?>" class="regular-text"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_book_button_background_color"><?php esc_html_e('Book Button Background Color', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[book_button_background_color]" type="text" id="bdpcp_settings_book_button_background_color" value="<?php echo esc_html($bdpcp_setting_default('book_button_background_color')); ?>" class="regular-text bdpcp-wp-color-picker"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_book_button_text_color"><?php esc_html_e('Book Button Text Color', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[book_button_text_color]" type="text" id="bdpcp_settings_book_button_text_color" value="<?php echo esc_html($bdpcp_setting_default('book_button_text_color')); ?>" class="regular-text bdpcp-wp-color-picker"></td>
                        </tr>

                        <tr>
                            <th scope="row"><label for="bdpcp_settings_unit_type_background_color"><?php esc_html_e('Unit Type Background Color', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[unit_type_background_color]" type="text" id="bdpcp_settings_unit_type_background_color" value="<?php echo esc_html($bdpcp_setting_default('unit_type_background_color')); ?>" class="regular-text bdpcp-wp-color-picker"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_unit_type_text_color"><?php esc_html_e('Unit Type Text Color', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[unit_type_text_color]" type="text" id="bdpcp_settings_unit_type_text_color" value="<?php echo esc_html($bdpcp_setting_default('unit_type_text_color')); ?>" class="regular-text bdpcp-wp-color-picker"></td>
                        </tr>
                    </tbody>
                </table>

            </div>
            <div class="bdpcp-tab-content" style="display: none;">
                <h1><?php esc_html_e('Labels', 'bookingdaddy-pro') ?></h1>

                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_date_selection_label"><?php esc_html_e('Date Selection Label', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[date_selection_label]" type="text" min="0" id="bdpcp_settings_date_selection_label" value="<?php echo esc_html($bdpcp_setting_default('date_selection_label')); ?>" class="regular-text"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_time_selection_label"><?php esc_html_e('Time Selection Label', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[time_selection_label]" type="text" min="0" id="bdpcp_settings_time_selection_label" value="<?php echo esc_html($bdpcp_setting_default('time_selection_label')); ?>" class="regular-text"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_duration_label"><?php esc_html_e('Duration Label', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[duration_label]" type="text" min="0" id="bdpcp_settings_duration_label" value="<?php echo esc_html($bdpcp_setting_default('duration_label')); ?>" class="regular-text"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_sub_total_label"><?php esc_html_e('Sub Total Label', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[sub_total_label]" type="text" min="0" id="bdpcp_settings_sub_total_label" value="<?php echo esc_html($bdpcp_setting_default('sub_total_label')); ?>" class="regular-text"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_additional_fee_label"><?php esc_html_e('Additional Fee Label', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[additional_fee_label]" type="text" min="0" id="bdpcp_settings_additional_fee_label" value="<?php echo esc_html($bdpcp_setting_default('additional_fee_label')); ?>" class="regular-text"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_total_amount_label"><?php esc_html_e('Total Amount Label', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[total_amount_label]" type="text" min="0" id="bdpcp_settings_total_amount_label" value="<?php echo esc_html($bdpcp_setting_default('total_amount_label')); ?>" class="regular-text"></td>
                        </tr>
                    </tbody>
                </table>

            </div>
            <div class="bdpcp-tab-content" style="display: none;">
                <h1><?php esc_html_e('Error Messages', 'bookingdaddy-pro') ?></h1>

                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_date_selection_error"><?php esc_html_e('Date Selection Error', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[date_selection_error]" type="text" min="0" id="bdpcp_settings_date_selection_error" value="<?php echo esc_html($bdpcp_setting_default('date_selection_error')); ?>" class="regular-text"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_time_selection_error"><?php esc_html_e('Time Selection Error', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[time_selection_error]" type="text" min="0" id="bdpcp_settings_time_selection_error" value="<?php echo esc_html($bdpcp_setting_default('time_selection_error')); ?>" class="regular-text"></td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="bdpcp_settings_unit_selection_error"><?php esc_html_e('Slot Selection Error', 'bookingdaddy-pro') ?></label></th>
                            <td><input name="bdpcp_settings[unit_selection_error]" type="text" min="0" id="bdpcp_settings_unit_selection_error" value="<?php echo esc_html($bdpcp_setting_default('unit_selection_error')); ?>" class="regular-text"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <div style="margin-top: 14px;display: flex; gap: 10px;">
            <?php submit_button(esc_html__('Save Changes', 'bookingdaddy-pro'), 'primary', 'bdpcp_save_changes', false); ?>
            <button class="button" name="bdpcp_restore_default"><?php esc_html_e('Restore Default', 'bookingdaddy-pro'); ?></button>
        </div>
    </form>
</div>