<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://conicplex.com
 * @since             1.0.0
 * @package           BDPCP
 *
 * @wordpress-plugin
 * Plugin Name:       BookingDaddy Pro – Booking & Appointment Made Bold, Easy, and Smart
 * Plugin URI:        https://conicplex.com/plugins/bookingdaddy-pro/
 * Description:       BookingDaddy Pro is a powerful and easy-to-use booking plugin that lets you manage appointments and reservations effortlessly.
 * Version:           1.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * Author:            ConicPlex
 * Author URI:        https://conicplex.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       bookingdaddy-pro
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (! defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('BDPCP_VERSION', '1.0.2');

define('BDPCP_ROOT_PATH', plugin_dir_path(__FILE__));
define('BDPCP_ROOT_URL', plugin_dir_url(__FILE__));

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-bdpcp-activator.php
 */
function bdpcp_activate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-bdpcp-activator.php';
	BDPCP_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-bdpcp-deactivator.php
 */
function bdpcp_deactivate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-bdpcp-deactivator.php';
	BDPCP_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'bdpcp_activate');
register_deactivation_hook(__FILE__, 'bdpcp_deactivate');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-bdpcp.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function bdpcp_run()
{

	$plugin = new BDPCP();
	$plugin->run();
}
bdpcp_run();
