<?php

/**
 * Fired during plugin activation
 *
 * @link       https://conicplex.com
 * @since      1.0.0
 *
 * @package    BDPCP
 * @subpackage BDPCP/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    BDPCP
 * @subpackage BDPCP/includes
 * @author     ConicPlex <hello@conicplex.com>
 */
class BDPCP_Activator
{

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate()
	{
		// Plugin insight code
		require_once BDPCP_ROOT_PATH . 'includes/class-bdpcp-insight.php';
		$bdpcp_insight = new BDPCP_Insight();
		$bdpcp_insight->send_insight('activation');

		// Deactivate the BookingDaddy plugin if it is active
		if (is_plugin_active('bookingdaddy/bookingdaddy.php')) {
			deactivate_plugins('bookingdaddy/bookingdaddy.php');

			echo '<div class="notice notice-warning is-dismissible"><p>BookingDaddy plugin has been deactivated to avoid conflicts.</p></div>';
		}
	}
}
