<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://conicplex.com
 * @since      1.0.0
 *
 * @package    BDPCP
 * @subpackage BDPCP/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    BDPCP
 * @subpackage BDPCP/includes
 * @author     ConicPlex <hello@conicplex.com>
 */
class BDPCP_Deactivator
{

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate()
	{
		$args = [];
		if (isset($_GET['bdpcp_deactivation_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['bdpcp_deactivation_nonce'])), 'bdpcp_deactivation_nonce_action')) {

			if (isset($_GET['bdpcp_deactivation_reason']) && !empty($_GET['bdpcp_deactivation_reason'])) {
				$args['deactivation_reason'] = sanitize_text_field(wp_unslash($_GET['bdpcp_deactivation_reason']));
			}
			if (isset($_GET['bdpcp_deactivation_reason_text']) && !empty($_GET['bdpcp_deactivation_reason_text'])) {
				$args['deactivation_reason_text'] = sanitize_text_field(wp_unslash($_GET['bdpcp_deactivation_reason_text']));
			}
		}

		// Plugin insight code
		require_once BDPCP_ROOT_PATH . 'includes/class-bdpcp-insight.php';
		$bdpcp_insight = new BDPCP_Insight();
		$bdpcp_insight->send_insight('deactivation', $args);
	}
}
